//
//  AccountsShowViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 12.02.23.
//

//
//  AccountsShownViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 12.02.23.
//

import UIKit
import JNGradientLabel

class AccountsShownViewController: UIViewController {
    
    @IBOutlet weak var topBarLabel: JNGradientLabel!
    
    
    @IBOutlet var informationText: UILabel!
    
    
    @IBOutlet var SwitchGiroAccount: UISwitch!
    
    
    
    @IBOutlet var checkboxGiroAccountLabel: UILabel!
    @IBOutlet var checkboxGiroAccountButton: UIButton!
    
    
    
    @IBOutlet var checkboxSavingsAccountLabel: UILabel!
    @IBOutlet var checkboxSavingsAccountButton: UIButton!
    
    
    @IBOutlet var checkboxInvestmentAccountLabel: UILabel!
    @IBOutlet var checkboxInvestmentAccountButton: UIButton!
    
    
    @IBOutlet var storeSettingsButton: UIButton!
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        UINavigationBar.appearance().titleTextAttributes = [.foregroundColor : UIColor.white,
                                                            .font : Fonts.mediumFontWithSize(size: 18)]
        
        self.navigationItem.backBarButtonItem?.tintColor = UIColor.white
        
        // top bar gradient color
        let gradientColors: [UIColor]    = [UIColor(red: 47.0/255.0, green: 67.0/255.0, blue: 99.0/255.0, alpha: 1.0), UIColor(red: 67/255.0, green: 114.0/255.0, blue: 196.0/255.0, alpha: 1.0)]
        let gradientlocations: [CGFloat] = [1.0, 0.0]
        
        topBarLabel.textColor = .white
        topBarLabel.textGradientLocation = .background
        topBarLabel.setAxialGradientParameters(startPoint: CGPoint(x: 0.0, y: 0.0),
                                                                endPoint: CGPoint(x: 1.0, y: 1.0),
                                                                colors: gradientColors,
                                                                locations: gradientlocations)
        
        informationText.textColor = Colors.greyColor
        informationText.font = Fonts.mediumFontWithSize(size: 16)
        informationText.text = "" // Wählen Sie aus welche Konten Ihnen auf Ihrer Übersicht angezeigt werden sollen.
        
        checkboxGiroAccountLabel.textColor = Colors.greyColor
        checkboxGiroAccountLabel.font = Fonts.mediumFontWithSize(size: 16)
        checkboxGiroAccountLabel.text = " LightBanking Giro Premium"
        
        checkboxSavingsAccountLabel.textColor = Colors.greyColor
        checkboxSavingsAccountLabel.font = Fonts.mediumFontWithSize(size: 16)
        checkboxSavingsAccountLabel.text = " LightBanking Savings"
        
        checkboxInvestmentAccountLabel.textColor = Colors.greyColor
        checkboxInvestmentAccountLabel.font = Fonts.mediumFontWithSize(size: 16)
        checkboxInvestmentAccountLabel.text = " LightBanking Depot"
        
        // style store settings button
        storeSettingsButton.titleLabel?.font = Fonts.mediumFontWithSize(size: 18)
        Utilities.styleFilledButtonAuthScreenGreenEdged(storeSettingsButton)
        
        
        if !hideAccountGiroPublic {
            checkboxGiroAccountButton.setImage(UIImage(named: "blue_on"), for: .selected)
        } else {
            checkboxGiroAccountButton.setImage(UIImage(named: "blue_off"), for: .normal)
        }
        
        if !hideAccountSavingsPublic {
            checkboxSavingsAccountButton.setImage(UIImage(named: "blue_on"), for: .selected)
        } else {
            checkboxSavingsAccountButton.setImage(UIImage(named: "blue_off"), for: .normal)
        }

        if !hideAccountInvestmentPublic {
            checkboxInvestmentAccountButton.setImage(UIImage(named: "blue_on"), for: .selected)
        } else {
            checkboxInvestmentAccountButton.setImage(UIImage(named: "blue_off"), for: .normal)
        }
        
        
        
        
        
        
        
        if hideAccountGiroPublic {
            SwitchGiroAccount.isOn = false
            checkboxGiroAccountButton.isSelected = false
        }
        if hideAccountSavingsPublic {
            checkboxSavingsAccountButton.isSelected = false
        }
        if hideAccountInvestmentPublic {
            checkboxInvestmentAccountButton.isSelected = false
        }
    }
    
    
    

    @IBAction func ShowAccountGiro(_ sender: UIButton) {
        
        hideAccountGiroPublic.toggle()
        
        if sender.isSelected {
            sender.isSelected = false
            sender.setImage(UIImage(named: "blue_off"), for: .normal)
        } else {
            sender.isSelected = true
            sender.setImage(UIImage(named: "blue_on"), for: .selected)
        }
        
        
        
        NotificationCenter.default.post(name: Notification.Name("hideAccountGiro"), object: nil)
        
    }
    
    
    @IBAction func showAccountSavings(_ sender: UIButton) {
        hideAccountSavingsPublic.toggle()
        
        if sender.isSelected {
            sender.isSelected = false
            sender.setImage(UIImage(named: "blue_off"), for: .normal)
            
        } else {
            sender.isSelected = true
            sender.setImage(UIImage(named: "blue_on"), for: .selected)
        }

    }
    
    @IBAction func showAccountInvestments(_ sender: UIButton) {
        hideAccountInvestmentPublic.toggle()
        
        if sender.isSelected {
            sender.isSelected = false
            sender.setImage(UIImage(named: "blue_off"), for: .normal)
            
        } else {
            sender.isSelected = true
            sender.setImage(UIImage(named: "blue_on"), for: .selected)
        }

    }
    
    
    
    // used with tabBarController.swift file
    @IBAction func backButton(_ sender: Any) {
        let tabBarController = self.storyboard?.instantiateViewController(withIdentifier: "OnlineBankingTBC") as! UITabBarController
        
        
        tabBarController.modalPresentationStyle = .fullScreen
        tabBarController.modalTransitionStyle = .crossDissolve
        present(tabBarController, animated: true)
        

        
        // https://www.youtube.com/watch?v=43LpNQtUvV4
        let indexData: [String: Int] = ["index" : 2]
        NotificationCenter.default.post(name: Notification.Name("changeIndex"), object: nil, userInfo: indexData)
    }
    
    
    @IBAction func toggleSwitchHideGiroAccount(_ sender: Any) {
        
        //hideAccountGiroPublic = true
        hideAccountGiroPublic.toggle()
        NotificationCenter.default.post(name: Notification.Name("hideAccountGiro"), object: nil)
        

        
        
    }
    
    
    
    
    
    @IBAction func storeSettingsButton(_ sender: Any) {
        let tabBarController = self.storyboard?.instantiateViewController(withIdentifier: "OnlineBankingTBC") as! UITabBarController
        
        self.view.window?.rootViewController = tabBarController
        self.view.window?.makeKeyAndVisible()
        
        let indexData: [String: Int] = ["index" : 2]
        NotificationCenter.default.post(name: Notification.Name("changeIndex"), object: nil, userInfo: indexData)
    }
    
    
}

